/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", description="Tamed animals do not take direct damage from players.", hasSubscriptions=true)
public class TamedAnimalsNoDamage
extends CharmModule {
    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        boolean result;
        if (!event.isCanceled() && (result = this.tryIgnoreAttack(event.getPlayer(), event.getEntity().func_130014_f_(), event.getTarget()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        boolean result;
        if (!event.isCanceled() && (result = this.tryIgnoreDamage(event.getEntityLiving(), event.getSource(), event.getAmount()))) {
            event.setCanceled(true);
        }
    }

    private boolean tryIgnoreAttack(PlayerEntity player, World world, Entity entity) {
        return entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n() && !player.func_184812_l_();
    }

    private boolean tryIgnoreDamage(LivingEntity entity, DamageSource damageSource, float amount) {
        if (!(entity instanceof PlayerEntity)) {
            Entity attacker = damageSource.func_76364_f();
            Entity source = damageSource.func_76346_g();
            PlayerEntity player = null;
            if (source instanceof PlayerEntity) {
                player = (PlayerEntity)source;
            }
            if (attacker instanceof PlayerEntity) {
                player = (PlayerEntity)attacker;
            }
            if (player != null && !player.func_184812_l_() && entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n()) {
                return true;
            }
        }
        return false;
    }
}

